#ifndef YZ_PAIR
#define YZ_PAIR

#include <set>
using namespace std;

namespace twong
{
	// A class/structure that stores a "y" and "z" value.
	// The < operator is needed for the STL set insert function.
	class yz_pair
	{
	public:
		int y;
		int z;
		friend bool operator <(yz_pair a, yz_pair b)
		{
			if (a.z == b.z)
			{
				return a.y < b.y;
			}
			else
			{
				return a.z < b.z;
			}
		}
	};

	void add_yz_pair(int y, int z, set<yz_pair> &collection)
	// Adds a yz_pair, specified by "y" and "z", to the given collection.
	{
		// Create the coordinate pair.
		yz_pair coord;
		coord.y = y;
		coord.z = z;
	
		// Add the coordinate to the collection.
		collection.insert(coord);
	}
} // namespace twong

#endif // YZ_PAIR
