#ifndef PINNED_SPACE
#define PINNED_SPACE

#include "pinned_plane.h"

namespace twong
{
	/*
	 * A node that connects pinned plane in the z-direction.
	 */
	struct z_node
	{
		// Hold the plane and it's z-value.
		pinned_plane *plane;
		int z_value;

		// Connect to the next z_node.
		z_node *z_next;
	};

	/*
	 * Class: Pinned Space
	 *
	 * This class is a collection of pinned planes, adding a z-dimension
	 * and thus creating a three dimensional space.
	 *
	 * Pinned planes are added as needed.
	 */
	class pinned_space : public pinned_plane
	{
	public:
		pinned_space();
		// Precondition:  None
		// Postcondition: Initializes the pinned space.

		~pinned_space();
		// the destructor

		pinned_plane& operator [](int index);
		// Precondition:  None
		// Postcondition: Returns the pinned plane with the given value
		//                of "z".

		void print() const;
		// Precondition:  None.
		// Postcondition: Prints each pinned plane contained by the
		//                space, in order.  Also prints the z-value
		//                of the plane before printing it.

		int getLength() const;
		// Precondition:  None.
		// Postcondition: Returns the number of pinned planes that have
		//                been allocated to this space.

		bool exists(int z) const;
		// Precondition:  None.
		// Postcondition: Returns true if a pinned plane has been
		//                allocated with the corresponding value
		//                of "z".
	private:
		z_node *head;
	};
} // namespace twong

#endif // PINNED_SPACE
