#include <iostream>
#include <cassert>
#include "pinned_space.h"
using namespace std;

namespace twong
{
	pinned_space::pinned_space()
	{
		// Start with no planes.
		head = NULL;
	}

	pinned_space::~pinned_space()
	{
		// Iterate through all the nodes and delete them.
		z_node *node_ptr = head;
		z_node *del_node;
		while (node_ptr != NULL)
		{
			// Assign the current node to be deleted.
			del_node = node_ptr;

			// Go to the next node.
			node_ptr = node_ptr->z_next;

			// Delete the node that we marked for deletion.
			delete del_node->plane;
			delete del_node;
		}
	}

	pinned_plane& pinned_space::operator [](int index)
	{
		// Go through each z_node to see if the index already exists.
		// They should be in order from least to greatest.  If it
		// does not exist, add it and return the new pinned plane.
		z_node *prev_ptr = NULL;
		z_node *node_ptr = head;
		while (1)
		{
			if (node_ptr == NULL)
			{
				// We reached the end of the nodes.  Insert
				// the new node here.

				// Create the node.
				z_node *new_node = new z_node;
				new_node->z_value = index;
				new_node->plane = new pinned_plane;
				new_node->z_next = NULL;

				// Insert the node.  If there were no elements
				// (prev_ptr is still NULL), then insert at the
				// head.
				if (prev_ptr == NULL)
				{
					head = new_node;
				}
				else
				{
					prev_ptr->z_next = new_node;
				}

				// Return the corresponding pinned plane.
				return *(new_node->plane);
			}
			else if (node_ptr->z_value == index)
			{
				// We found the node.  Return the corresponding
				// pinned plane.
				return *(node_ptr->plane);
			}
			else if (node_ptr->z_value > index)
			{
				// Between the current node and the previous
				// node, so things stay in order.

				// Create the node.
				z_node *new_node = new z_node;
				new_node->z_value = index;
				new_node->plane = new pinned_plane;
				new_node->z_next = node_ptr;

				// Insert the node.
				if (prev_ptr == NULL)
				{
					// We're inserting at the beginning of the
					// linked list.
					head = new_node;
				}
				else
				{
					// We're inserting between two nodes.
					prev_ptr->z_next = new_node;
				}

				// Return the corresponding pinned plane.
				return *(new_node->plane);
			}
			else if (node_ptr->z_value < index)
			{
				// Go to the next node.
				prev_ptr = node_ptr;
				node_ptr = node_ptr->z_next;
			}
			else
			{
				// We shouldn't reach here.  If we do, error.
				assert(true == false);
			}
		}
	}

	void pinned_space::print() const
	{
		// Iterate through each z-node.
		z_node *node_ptr = head;
		while (node_ptr != NULL)
		{
			// Print the z-value of this node.
			cout << "z-value: " << node_ptr->z_value << endl;

			// Print the contents of this node.
			node_ptr->plane->print();

			// Go to the next z-node.
			node_ptr = node_ptr->z_next;
		}
	}

	int pinned_space::getLength() const
	{
		// Keep track of the number of planes.
		int i = 0;

		// Iterate through each z-node.
		z_node *node_ptr = head;
		while (node_ptr != NULL)
		{
			// Increment the counter.
			i++;

			// Go to the next z-node.
			node_ptr = node_ptr->z_next;
		}

		// Return the count.
		return i;
	}

	bool pinned_space::exists(int index) const
	{
		// Iterate through each z-node.
		z_node *node_ptr = head;
		while (node_ptr != NULL)
		{
			// Return true if we have a match.
			if (node_ptr->z_value == index)
			{
				return true;
			}

			// Go to the next z-node.
			node_ptr = node_ptr->z_next;
		}
		return false;
	}
} // namespace twong
