#ifndef PINNED_PLANE
#define PINNED_PLANE

#include "pinned_growable_array.h"

namespace twong
{
	/*
	 * A node that connects pinned, growable arrays in the y-direction.
	 */
	struct y_node
	{
		// Hold the array and it's y-value.
		pinned_growable_array *array;
		int y_value;

		// Connect to the next y_node.
		y_node *y_next;
	};

	/*
	 * Class: Pinned Plane
	 *
	 * This class is a collection of pinned, growable arrays that form a
	 * two dimensional space.  Assuming each pinned, growable array is
	 * along the x-direction, "pinned plane" assigns a unique "y" index
	 * index to each array, which are used to address them.
	 *
	 * Pinned, growable arrays are added to the pinned plane as needed.
	 * They are pinned at one less than their y-values (i.e., the starting
	 * index of each pinned, growable array is one less that its y-value.
	 */
	class pinned_plane : public pinned_growable_array
	{
	public:
		pinned_plane();
		// Precondition:  None
		// Postcondition: Initializes the pinned plane.

		~pinned_plane();
		// the destructor

		pinned_growable_array& operator [](int index);
		// Precondition:  None
		// Postcondition: Returns the pinned, growable array with the
		//                given values of "y".

		void print() const;
		// Precondition:  None.
		// Postcondition: Prints each pinned, growable array contained
		//                by the plane, in order.  Also prints the
		//                y-value of the array before printing it.

		int getLength() const;
		// Precondition:  None.
		// Postcondition: Returns the number of pinned, growable arrays
		//                that have been allocated to this plane.

		bool exists(int y) const;
		// Precondition:  None.
		// Postcondition: Returns true if a pinned, growable array has
		//                been allocated with the corresponding value
		//                of "y".
	private:
		y_node *head;
	};
} // namespace twong

#endif // PINNED_PLANE
