#include <iostream>
#include <cassert>
#include "pinned_plane.h"
using namespace std;

namespace twong
{
	pinned_plane::pinned_plane()
	{
		// Start with no arrays.
		head = NULL;
	}

	pinned_plane::~pinned_plane()
	{
		// Iterate through all the nodes and delete them.
		y_node *node_ptr = head;
		y_node *del_node;
		while (node_ptr != NULL)
		{
			// Assign the current node to be deleted.
			del_node = node_ptr;

			// Go to the next node.
			node_ptr = node_ptr->y_next;

			// Delete the node that we marked for deletion.
			delete del_node->array;
			delete del_node;
		}
	}

	pinned_growable_array& pinned_plane::operator [](int index)
	{
		// Go through each y_node to see if the index already exists.
		// They should be in order from least to greatest.  If it
		// does not exist, add it and return the new pinned, growable
		// array.
		y_node *prev_ptr = NULL;
		y_node *node_ptr = head;
		while (1)
		{
			if (node_ptr == NULL)
			{
				// We reached the end of the nodes.  Insert
				// the new node here.

				// Create the node.
				y_node *new_node = new y_node;
				new_node->y_value = index;
				new_node->array = new pinned_growable_array(new_node->y_value - 1);
				new_node->y_next = NULL;

				// Insert the node.  If there were no elements
				// (prev_ptr is still NULL), then insert at the
				// head.
				if (prev_ptr == NULL)
				{
					head = new_node;
				}
				else
				{
					prev_ptr->y_next = new_node;
				}

				// Return the corresponding pinned, growable
				// array.
				return *(new_node->array);
			}
			else if (node_ptr->y_value == index)
			{
				// We found the node.  Return the corresponding
				// pinned, growable array.
				return *(node_ptr->array);
			}
			else if (node_ptr->y_value > index)
			{
				// Between the current node and the previous
				// node, so things stay in order.

				// Create the node.
				y_node *new_node = new y_node;
				new_node->y_value = index;
				new_node->array = new pinned_growable_array(new_node->y_value - 1);
				new_node->y_next = node_ptr;

				// Insert the node.
				if (prev_ptr == NULL)
				{
					// We're inserting at the beginning of the
					// linked list.
					head = new_node;
				}
				else
				{
					// We're inserting between two nodes.
					prev_ptr->y_next = new_node;
				}

				// Return the corresponding pinned, growable
				// array.
				return *(new_node->array);
			}
			else if (node_ptr->y_value < index)
			{
				// Go to the next node.
				prev_ptr = node_ptr;
				node_ptr = node_ptr->y_next;
			}
			else
			{
				// We shouldn't reach here.  If we do, error.
				assert(true == false);
			}
		}
	}

	void pinned_plane::print() const
	{
		// Iterate through each y-node.
		y_node *node_ptr = head;
		while (node_ptr != NULL)
		{
			// Print the y-value of this node.
			cout << "\ty-value: " << node_ptr->y_value << endl;

			// Print the contents of this node.
			node_ptr->array->print();

			// Go to the next y-node.
			node_ptr = node_ptr->y_next;
		}
	}

	int pinned_plane::getLength() const
	{
		// Keep track of the number of arrays.
		int i = 0;

		// Iterate through each y-node.
		y_node *node_ptr = head;
		while (node_ptr != NULL)
		{
			// Increment the counter.
			i++;

			// Go to the next y-node.
			node_ptr = node_ptr->y_next;
		}

		// Return the count.
		return i;
	}

	bool pinned_plane::exists(int index) const
	{
		// Iterate through each y-node.
		y_node *node_ptr = head;
		while (node_ptr != NULL)
		{
			// Return true if we have a match.
			if (node_ptr->y_value == index)
			{
				return true;
			}

			// Go to the next y-node.
			node_ptr = node_ptr->y_next;
		}
		return false;
	}
} // namespace twong
