#ifndef PINNED_GROWABLE_ARRAY
#define PINNED_GROWABLE_ARRAY

namespace twong
{
	/*
	 * Class: Pinned, Growable Array
	 *
	 * This class is a one-dimensional array that has a fixed starting
	 * index that can be any integer (including negative).  It grows towards
	 * larger indices (i.e., "to the right"), as needed.
	 *
	 * Invariants:
	 * 1) The starting index, which is the smallest possible index for the
	 *    array, will be stored in "starting_index."
	 * 2) When the array grows, unassigned portions are set to zero.
	 */
	class pinned_growable_array
	{
	public:
		pinned_growable_array();
		// Precondition:  None
		// Postcondition: Creates a pinned, growable array that is
		//                pinned at index zero.

		pinned_growable_array(int index);
		// Precondition:  None
		// Postcondition: Creates a pinned, growable array that is
		//                pinned at index "index"

		pinned_growable_array(const pinned_growable_array& a);
		// Precondition:  None
		// Postcondition: Creates a pinned, growable array that is a
		//                copy of "a".

		~pinned_growable_array();
		// the destructor

		double& operator [](int index);
		// Precondition:  None
		// Postcondition: Returns the value of the pinned, growable
		//                array at "index".  "index" must be greater
		//                than or equal to "starting_index".

		pinned_growable_array& operator =(const pinned_growable_array& a);
		// Precondition:  The pinned, growable arrays have the same
		//                starting index.
		// Postcondition: Copies "a" into the target array.

		double sum();
		// Precondition:  None
		// Postcondition: Returns the sum of all the values in the
		// 		  pinned, growable array.

		void zero();
		// Precondition:  None
		// Postcondition: Sets each value of the pinned, growable array
		//                to zero.

		void print() const;
		// Precondition:  None.
		// Postcondition: Prints each index and corresponding value,
		//                separated by a tab and ended by a newline.

		int getStartingIndex() const;
		// Precondition:  None
		// Postcondition: Returns the starting index.

		bool exists(int index) const;
		// Precondition:  None.
		// Postcondition: Returns true if the index exists in the
		//                pinned, growable array (i.e., if the
		//                index is within the starting_index and the
		//                allocated length).  Returns false otherwise.
		//                Note: unlike other functions, this does *not*
		//                grow the length of the array.

		int getLength() const;
		// Precondition:  None.
		// Postcondition: Returns the length of the pinned, growable
		//                array.
	private:
		void copy(const pinned_growable_array &a);
		// Used by the copy constructor and the assignment operator to
		// make a copy of the pinned, growable array into the target.

		double *array;
		int starting_index;
		int length;
	};
} // namespace twong

#endif // PINNED_GROWABLE_ARRAY
