#include <iostream>
#include <cstring> // memset
#include <cassert>
#include "pinned_growable_array.h"
using namespace std;

namespace twong
{
	pinned_growable_array::pinned_growable_array()
	{
		// Start with an array with one element.
		array = new double[1];
		length = 1;

		// Zero the value of the one element.
		array[0] = 0.0;

		// Set the starting index.
		starting_index = 0;
	}

	pinned_growable_array::pinned_growable_array(int index)
	{
		// Start with an array with one element.
		array = new double[1];
		length = 1;

		// Zero the value of the one element.
		array[0] = 0.0;

		// Set the starting index.
		starting_index = index;
	}

	pinned_growable_array::pinned_growable_array(const pinned_growable_array& a)
	{
		// Make the target a copy of "a".
		copy(a);
	}

	pinned_growable_array::~pinned_growable_array()
	{
		delete [] array;
	}

	double& pinned_growable_array::operator [](int index)
	{
		// Make sure the requested index is greater than or equal to
		// the starting index.
		assert(index >= starting_index);

		// If the requested index is outside the currenty allocated
		// region, increase the size of the array to twice the
		// requested length.
		if (index > starting_index + length - 1)
		{
			// Allocate the new array.
			int newlength = 2 * (index - starting_index);
			double *newarray = new double[newlength + 1];

			// Copy the contents over.
			for (int i = 0; i < length; ++i)
			{
				newarray[i] = array[i];
			}

			// Zero the end of the new array.
			for (int i = length; i < newlength; ++i)
			{
				newarray[i] = 0.0;
			}

			// Switch to the new array and delete the
			// existing one.
			double *tmp = array;
			array = newarray;
			length = newlength;
			delete [] tmp;
		}

		// Return the corresponding array entry.
		return array[index - starting_index];
	}

	pinned_growable_array& pinned_growable_array::operator =(const pinned_growable_array& a)
	{
		// Don't do anything if you assign a symmetric array to itself
		if (this != &a)
		{
			// Clear the existing memory for the symmetric array
			this->~pinned_growable_array();

			// Make a copy
			this->copy(a);
		}
		return *this; // necessary for multiple assignment
	}

	double pinned_growable_array::sum()
	{
		double ans = 0.0;
		for (int i = 0; i < length; ++i)
		{
			ans += array[i];
		}
		return ans;
	}

	void pinned_growable_array::zero()
	{
		// Set the elements to zero.
		memset(array, 0, sizeof(double) * length);
	}

	void pinned_growable_array::print() const
	{
		cout << "\t\tx=\tp=" << endl;
		for (int i = 0; i < length; ++i)
		{
			cout << "\t\t" << i + starting_index << "\t" << array[i] << endl;
		}
	}

	int pinned_growable_array::getStartingIndex() const
	{
		return starting_index;
	}

	bool pinned_growable_array::exists(int index) const
	{
		// Check whether the index is beyond bounds.
		if (index > starting_index + length - 1 || index < starting_index)
		{
			return false;
		}

		// If we reach this point, the index is within bounds.
		return true;
	}

	int pinned_growable_array::getLength() const
	{
		// Return the length.
		return length;
	}

	void pinned_growable_array::copy(const pinned_growable_array& a)
	// Makes the symmetric array a copy of a
	{
		// Make the copy the same length.
		length = a.length;
		array = new double[length];

		// Copy all the values over.
		for (int i = 0; i < length; ++i)
		{
			array[i] = a.array[i];
		}

		// Copy the starting index.
		starting_index = a.starting_index;
	}
} // namespace twong
