#ifndef HEAT_TRAD
#define HEAT_TRAD

#include "pinned_growable_array.h"

namespace twong
{
	/*
	 * Class: Heat, Traditional Method
	 *
	 * Runs the traditional method of solving the heat equation on the
	 * supplied pinned, growable array.
	 */
	class heat_trad
	{
	public:
		heat_trad(double Cutoff, double Dx, double Dt);
		// Precondition:  Cutoff, Dt, and Dx are positive.
		// Postcondition: Initializes the solver to start with the
		//                traditional method, sets the cutoff, dx, and
		//                dt.

		~heat_trad();
		// the destructor

		void nextstep(pinned_growable_array& x_next, pinned_growable_array& x_current, int right_end_index);
		// Precondition:  "x_next" and "x_current" have the same starting index.
		//                "right_end_index" must be greater than the starting index.
		// Postcondition: Solves the heat equation using the traditional
		//                method for one time step, starting at the point next
		//                to the starting index and continuing to the right
		//                until "right_end_index."  Afterwards, the heat
		//                equation is continued to be solved until the value of
		//                "x_current" drops below the cutoff.

		void set_cutoff(double Cutoff);
		// Precondition:  None.
		// Postcondition: Sets the cutoff.

		void set_dx(double Dx);
		// Precondition:  None.
		// Postcondition: Sets dx.

		void set_dt(double Dt);
		// Precondition:  None.
		// Postcondition: Sets dt.
		
		double get_dt();
		// Precondition:  None.
		// Postcondition: Returns dt.
	private:
		void trad(pinned_growable_array& x_next, pinned_growable_array& x_current, int right_end_index);
		/*
		 * Calculates the next time step of the heat equation using the traditional
		 * method based on the current time step.
		 * Parameters:
		 * - x_next    = next time step of the heat equation (returned)
		 * - x_current = current time step
		 * - factor    = dt / (dx * dx)
		 * - cuttoff   = terms are calculated starting at index 0 until the terms
		 *               become less than "cutoff"
		 */

		void set_factor();
		// Calculates the factor from dx and dt and stores it.

		// Parameters for solving the heat equation.
		double cutoff;
		double dt;
		double dx;
		double factor;
	};
}

#endif // HEAT_TRAD
